function adot=derivs(t,X)
%DERIVS: Unterprogramm fuer ODE-Solver

%global
global vs AE UF m1 m2 m3 ms mt m0 P0 P gam v0 ort0 position tmax getroffen zeitgetroffen minSM
   
%Ortskoordinaten der Objekte
x1=X(1:2);
x2=X(5:6);
x3=X(9:10);
x4=X(13:14);
%Abstaende der Objekte
d12=(x2-x1)/(norm(x2-x1))^3;
d13=(x3-x1)/(norm(x3-x1))^3;
d14=(x4-x1)/(norm(x4-x1))^3;
d24=(x4-x2)/(norm(x4-x2))^3;
d34=(x4-x3)/(norm(x4-x3))^3;
P=(P0*0.98*AE/norm(x4-x1))^2;
ms=m0+mt*P0/P;

dP=(x4-x1)/(norm(x4-x1));	%Ortsabhngigkeit der Leistung (Energieleistung der Sonne ~ d^2)
%Triebwerksleistung
P=P0;
if (norm(x4-x3)<minSM*AE) %minSM	= minimaler Sonden Mars Abstand fr Einfang in AE
   getroffen=1;
   zeitgetroffen=t/4;
else 
   getroffen=0;
   zeitgetroffen=0;
end


%Geschwindigkeitszunahme
vs=sqrt(2*P*t/ms);   
vec1=dP(1);
vec2=dP(2);
vec=[-vec2 vec1];
vsat=vs*vec;

%Ortsabhngigkeit der Geschwindigkeit
vsat=vsat*(ort0/norm(x4-x1))^2;

%Zeitabhngigkeit der Geschwindigkeit

%DGL-Systeme
%Sonne
adot(3:4)=0;
adot(1:2)=0;
%Erde
adot(5:6)=X(7:8);
adot(7:8)=gam.*(m1.*d12);
%Mars
adot(9:10)=X(11:12);
adot(11:12)=gam.*(m1.*d13);
%Sonde
adot(13:14)=X(15:16);
adot(15)=(gam*(m1*d14(1)+m2*d24(1)+m3*d34(1))+vsat(1));
adot(16)=(gam*(m1*d14(2)+m2*d24(2)+m3*d34(2))+vsat(2));
adot=adot(:);







